$TITLE: 26 COUNTRIE INSIDE MONEY STRUCTURE: BY CHUNDING LI
OPTION NLP=CONOPT

SET
R    COUNTRIES    /AUSTRALIA,BAHRAIN,BRAZIL,BRUNEI,CANADA,CHILE,CHINA,EU,INDIA,INDONESIA,JAPAN,KOREA,
                   KUWAIT,MALAYSIA,MEXICO,NEWZEALAND,PERU,PHILIPPINE,QATAR,RUSSIAN,ARABIA,SINGAPORE,
                   THAILAND,US,VIETNAM,ROW/
G    SECTORS      /TRADABLE, NONTRADABLE/
F    FACTORS      /K,L/
;
ALIAS (R,RR),(R,RRR),(G,GG),(F,FF);

PARAMETERS
PRN1(R,G)         TOTAL PRODUCTION
FACDEM1(R,G,F)    FACTOR DEMAND IN PRODUCTION
ELASP0(R,G)       FACTOR ELASTICITY OF SUBSTITUTION

TGDEM1(R)         ARMINGTON TRADABLE COMPOSITE GOODS DEMAND
/AUSTRALIA           364.1
 BAHRAIN             25.8
 BRAZIL              367.4
 BRUNEI              6.3
 CANADA              763.6
 CHILE               98.9
 CHINA               6159
 EU                  4376.6
 INDIA               1307.9
 INDONESIA           555.7
 JAPAN               1516.3
 KOREA               731.2
 KUWAIT              48.4
 MALAYSIA            234.3
 MEXICO              632.3
 NEWZEALAND          66.8
 PERU                80.5
 PHILIPPINE          180.0
 QATAR               64.7
 RUSSIAN             372.2
 ARABIA              247.3
 SINGAPORE           380.6
 THAILAND            284.3
 US                  4870
 VIETNAM             303.1
 ROW                 8205.0/,
GDEM1(R,RR)       TRADABLE GOODS DEMAND
NGDEM1(R)         NONTRADABLE GOODS DEMAND
/AUSTRALIA           971.9
 BAHRAIN             10.1
 BRAZIL              1391.6
 BRUNEI              2.3
 CANADA              868.3
 CHILE               171.6
 CHINA               6738.8
 EU                  13946.6
 INDIA               1521.0
 INDONESIA           428.3
 JAPAN               3281.5
 KOREA               783.0
 KUWAIT              43.1
 MALAYSIA            66.9
 MEXICO              490.7
 NEWZEALAND          121.8
 PERU                112.3
 PHILIPPINE          144.9
 QATAR               62.5
 RUSSIAN             1015.7
 ARABIA              342.3
 SINGAPORE           174.9
 THAILAND            197.7
 US                  16160.7
 VIETNAM             71.7
 ROW                 1508.3/,

MONEY1(R)         INSIDE MONEY
/AUSTRALIA           1017.3
 BAHRAIN             993.7
 BRAZIL              1058.7
 BRUNEI              1002.4
 CANADA              990.5
 CHILE               1001.3
 CHINA               1359.3
 EU                  973.1
 INDIA               814.9
 INDONESIA           991.5
 JAPAN               990.0
 KOREA               1069.6
 KUWAIT              1036
 MALAYSIA            1029.9
 MEXICO              986.4
 NEWZEALAND          996.1
 PERU                1004.8
 PHILIPPINE          952.4
 QATAR               1052.6
 RUSSIAN             1211.3
 ARABIA              1159.3
 SINGAPORE           1041.2
 THAILAND            1003.3
 US                  53.9
 VIETNAM             1006.8
 ROW                 1203.7/,

ELASC10(R)         ELASTICITY OF ARMINGTON CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ELASC20(R)         ELASTICITY OF GOODS CONSUMPTION
/AUSTRALIA           1.0
 BAHRAIN             1.0
 BRAZIL              1.0
 BRUNEI              1.0
 CANADA              1.0
 CHILE               1.0
 CHINA               1.0
 EU                  1.0
 INDIA               1.0
 INDONESIA           1.0
 JAPAN               1.0
 KOREA               1.0
 KUWAIT              1.0
 MALAYSIA            1.0
 MEXICO              1.0
 NEWZEALAND          1.0
 PERU                1.0
 PHILIPPINE          1.0
 QATAR               1.0
 RUSSIAN             1.0
 ARABIA              1.0
 SINGAPORE           1.0
 THAILAND            1.0
 US                  1.0
 VIETNAM             1.0
 ROW                 1.0/,

ENDW(R,F)         ENDOWMENT OF FACTORS BY INDIVIDUAL
TARIFF(R,RR)      IMPORT TARIFF
NTARIFF(R,RR)     NON-TARIFF BARRIER
RTA(R,RR)         PARAMETER OF TARIFF USED FOR CALCULATING FTA CHANGE
FTA(R,RR)         JOINT FTA EFFECT
WAR(R,RR)         CHINA-US TRADE WAR
;

TABLE PRN1(R,G)
                    TRADABLE          NONTRADABLE
AUSTRALIA           381.4             1052.5
BAHRAIN             19.5              18.2
BRAZIL              426.1             1442.5
BRUNEI              8.7               4.9
CANADA              754.1             959.2
CHILE               100.2             198.0
CHINA               6518.3            7089.9
EU                  4349.7            14398.9
INDIA               1122.8            1595.9
INDONESIA           547.2             495
JAPAN               1506.3            3465
KOREA               800.8             818.6
KUWAIT              84.4              56.2
MALAYSIA            264.2             94.4
MEXICO              618.7             602.0
NEWZEALAND          62.9              142.0
PERU                85.3              136.8
PHILIPPINE          132.4             198.5
QATAR               117.3             74.1
RUSSIAN             583.5             1074.1
ARABIA              406.6             379.9
SINGAPORE           421.8             242.4
THAILAND            287.6             217.3
US                  3923.9            16620.4
VIETNAM             309.9             115.3
ROW                 8408.7            2655.4  ;

TABLE FACDEM1(R,G,F)
                                     K                L
AUSTRALIA.TRADABLE                   91.5             289.9
AUSTRALIA.NONTRADABLE                252.6            799.9
BAHRAIN.TRADABLE                     6.3              13.2
BAHRAIN.NONTRADABLE                  5.8              12.4
BRAZIL.TRADABLE                      63.9             362.2
BRAZIL.NONTRADABLE                   216.4            1226.1
BRUNEI.TRADABLE                      3.5              5.2
BRUNEI.NONTRADABLE                   2.1              2.8
CANADA.TRADABLE                      173.5            580.6
CANADA.NONTRADABLE                   220.6            738.6
CHILE.TRADABLE                       23.1             77.1
CHILE.NONTRADABLE                    45.5             152.5
CHINA.TRADABLE                       2868             3650.3
CHINA.NONTRADABLE                    3119.6           3970.3
EU.TRADABLE                          913.4            3436.3
EU.NONTRADABLE                       3023.8           11375.1
INDIA.TRADABLE                       348.1            774.7
INDIA.NONTRADABLE                    494.7            1101.2
INDONESIA.TRADABLE                   191.5            355.7
INDONESIA.NONTRADABLE                173.3            321.7
JAPAN.TRADABLE                       361.5            1144.8
JAPAN.NONTRADABLE                    831.6            2633.4
KOREA.TRADABLE                       240.2            560.6
KOREA.NONTRADABLE                    245.6            573
KUWAIT.TRADABLE                      21.1             63.3
KUWAIT.NONTRADABLE                   14.1             42.1
MALAYSIA.TRADABLE                    63.4             200.8
MALAYSIA.NONTRADABLE                 22.7             71.7
MEXICO.TRADABLE                      142.3            476.4
MEXICO.NONTRADABLE                   138.5            463.5
NEWZEALAND.TRADABLE                  15.1             47.8
NEWZEALAND.NONTRADABLE               34.1             107.9
PERU.TRADABLE                        17.9             67.4
PERU.NONTRADABLE                     28.7             108.1
PHILIPPINE.TRADABLE                  35.7             96.7
PHILIPPINE.NONTRADABLE               53.6             144.9
QATAR.TRADABLE                       50.4             66.9
QATAR.NONTRADABLE                    31.9             42.2
RUSSIAN.TRADABLE                     134.1            449.4
RUSSIAN.NONTRADABLE                  247.1            827.0
ARABIA.TRADABLE                      97.6             309.0
ARABIA.NONTRADABLE                   91.2             288.7
SINGAPORE.TRADABLE                   113.9            307.9
SINGAPORE.NONTRADABLE                65.4             177.0
THAILAND.TRADABLE                    71.9             215.7
THAILAND.NONTRADABLE                 54.3             163.0
US.TRADABLE                          1824             2099.9
US.NONTRADABLE                       2490.3           14130.1
VIETNAM.TRADABLE                     83.7             226.2
VIETNAM.NONTRADABLE                  31.1             84.2
ROW.TRADABLE                         2018.1           6390.6
ROW.NONTRADABLE                      637.3            2018.1   ;


TABLE ELASP0(R,G)
                    TRADABLE           NONTRADABLE
AUSTRALIA           1.0                1.0
BAHRAIN             1.0                1.0
BRAZIL              1.0                1.0
BRUNEI              1.0                1.0
CANADA              1.0                1.0
CHILE               1.0                1.0
CHINA               1.0                1.0
EU                  1.0                1.0
INDIA               1.0                1.0
INDONESIA           1.0                1.0
JAPAN               1.0                1.0
KOREA               1.0                1.0
KUWAIT              1.0                1.0
MALAYSIA            1.0                1.0
MEXICO              1.0                1.0
NEWZEALAND          1.0                1.0
PERU                1.0                1.0
PHILIPPINE          1.0                1.0
QATAR               1.0                1.0
RUSSIAN             1.0                1.0
ARABIA              1.0                1.0
SINGAPORE           1.0                1.0
THAILAND            1.0                1.0
US                  1.0                1.0
VIETNAM             1.0                1.0
ROW                 1.0                1.0  ;

TABLE GDEM1(R,RR)

                    AUSTRALIA   BAHRAIN   BRAZIL    BRUNEI   CANADA    CHILE    CHINA      EU       INDIA   INDONESIA   JAPAN     KOREA     KUWAIT   MALAYSIA   MEXICO
AUSTRALIA           128.6       0.075     0.664     0.582    1.703     0.372    57.699     41.871   3.846   2.801       4.242     10.182    0.042    8.311      1.001
BAHRAIN             0.946       5.2       0.673     0        0.186     0.103    1.878      2.548    0.769   0.087       0.795     0.251     0.112    0.137      0.074
BRAZIL              1.125       0.117     186.2     0.001    2.252     3.382    34.731     38.759   3.663   1.331       4.356     5.381     0.213    1.531      4.369
BRUNEI              0.047       0         0.001     2.1      0.007     0.002    1.641      0.721    0.069   0.072       0.001     0.097     0        0.451      0.004
CANADA              1.619       0.028     4.247     0.006    303.7     1.396    58.319     48.177   3.958   1.358       12.997    7.295     0.031    2.302      14.034
CHILE               0.258       0.001     6.678     0.001    0.889     24.7     17.504     11.612   0.977   0.194       2.491     1.871     0        0.247      2.059
CHINA               105.083     0.151     77.142    0.248    28.354    26.999   4024.1     245.173  18.851  27.127      180.402   204.566   15.359   34.413     7.169
EU                  13.169      1.695     37.131    0.152    36.031    9.562    465.022    2041.5   53.978  19.516      82.859    60.026    3.875    30.169     30.512
INDIA               14.081      0.585     4.621     0.433    3.467     1.669    73.605     52.755   800.3   13.725      12.537    16.388    7.805    8.991      1.378
INDONESIA           5.826       0.069     1.803     0.021    1.841     0.115    45.537     11.137   5.017   367.0       17.977    9.089     0.267    8.603      0.287
JAPAN               45.681      1.241     6.886     2.269    11.731    7.409    173.612    74.271   5.498   19.479      768.1     32.112    7.248    17.109     3.275
KOREA               20.717      0.563     3.908     0.611    5.751     4.475    106.488    57.541   5.885   9.532       54.603    196.0     12.794   8.344      2.277
KUWAIT              0           0.771     0.291     0.001    0.243     0.032    5.979      6.589    1.861   0.228       2.104     1.408     12.5     0.307      0.209
MALAYSIA            5.345       0.109     1.965     0.433    0.809     0.125    43.316     16.562   6.559   9.437       15.729    9.629     0.478    16.900     0.368
MEXICO              0.328       0.0445    6.508     0.001    10.752    1.667    83.509     45.984   5.232   1.587       18.189    16.725    0.017    2.073      168.0
NEWZEALAND          5.019       0.009     0.126     0.001    0.487     0.089    8.643      6.601    0.509   0.643       3.036     2.004     0.009    1.447      0.317
PERU                0.116       0.001     2.415     0        0.703     1.367    10.059     4.349    0.902   0.286       1.054     0.972     0.001    0.234      1.647
PHILIPPINE          1.538       0.024     0.642     0.036    0.791     0.041    22.579     8.932    1.784   6.789       11.397    11.503    1.394    4.285      0.154
QATAR               0.703       0.009     0.321     0        0.169     0.014    3.916      12.441   1.991   0.149       1.383     0.588     0.327    0.322      0.192
RUSSIAN             0.671       0.007     2.471     0        0.746     1.058    52.218     99.729   3.225   1.715       8.822     7.009     0        1.627      0.938
ARABIA              0.649       1.555     2.309     0.001    1.714     0.148    22.244     34.641   5.685   1.578       5.474     4.301     0.417    1.167      0.745
SINGAPORE           5.457       0.124     1.555     0.525    1.542     0.091    49.634     43.516   7.262   12.992      22.149    14.193    4.073    34.471     2.346
THAILAND            5.935       0.166     2.064     0.859    0.981     0.452    49.953     17.522   4.863   8.045       35.259    8.847     0.929    14.062     0.653
US                  10.209      1.025     32.286    0.102    325.684   12.201   563.203    472.782  56.444  18.472      145.902   76.201    2.126    22.525     344.661
VIETNAM             3.201       0.013     1.838     0.052    0.799     0.283    58.533     12.971   3.955   3.656       16.917    46.943    0.288    8.475      0.788
ROW                 5.077       5.918     41.355    0.265    12.768    2.448    484.378    941.016  119.717 19.401      77.525    57.219    14.095   35.697     31.243

+
                    NEWZEALAND  PERU    PHILIPPINE  QATAR    RUSSIAN   ARABIA   SINGAPORE  THAILAND     US        VIETNAM    ROW
AUSTRALIA           6.057       0.256    0.551      0.355    0.181     0.476    8.822      11.524       24.666    3.966      45.255
BAHRAIN             0.053       0.002    0.029      0        0.099     6.814    0.111      0.286        1.206     0.173      3.268
BRAZIL              0.061       1.811    0.271      0.273    3.374     2.319    0.646      1.651        29.351    2.059      38.173
BRUNEI              0.005       0        0.014      0.003    0.001     0.002    0.374      0.109        0.361     0.017      0.201
CANADA              0.579       1.099    1.121      0.069    1.141     2.939    0.974      2.749        235.118   3.014      55.33
CHILE               0.138       1.156    0.052      0        0.071     0.033    0.101      0.987        13.999    0.768      12.113
CHINA               11.079      15.213   8.698      9.091    58.887    45.899   33.638     44.919       156.004   41.366     739.069
EU                  4.075       7.183    9.359      8.525    179.625   36.076   23.509     26.886       313.541   45.089     837.535
INDIA               0.633       2.454    0.615      10.587   6.801     28.431   14.437     7.647        32.715    6.544      184.696
INDONESIA           0.808       0.056    0.958      1.411    1.551     4.911    21.439     10.953       10.212    3.534      25.278
JAPAN               2.651       2.454    9.473      14.856   15.587    33.775   9.733      25.058       83.571    18.834     124.387
KOREA               1.379       2.474    2.542      16.294   17.504    26.336   7.974      5.582        59.081    18.241     84.304
KUWAIT              0.068       0.004    0.071      0.051    0.229     2.042    0.151      0.409        3.104     0.527      9.221
MALAYSIA            0.826       0.112    1.929      0.676    1.157     4.433    25.474     12.035       16.094    4.065      39.735
MEXICO              0.291       0.474    0.606      0.059    1.969     0.089    1.669      6.359        216.271   2.239      41.658
NEWZEALAND          23.1        0.039    0.099      0.055    0.166     0.387    1.476      1.921        4.425     0.639      5.553
PERU                0.133       37.4     0.058      0.019    0.438     0.183    0.068      0.401        9.174     0.353      8.167
PHILIPPINE          0.518       0.108    64.9       0.389    1.301     1.892    6.311      7.948        8.297     3.465      12.982
QATAR               0.032       0.072    0.072      33.0     0.282     0.015    0.214      0.367        6.177     0.258      1.686
RUSSIAN             0.136       0.182    0.417      0.036    132.0     0.292    0.869      1.856        12.691    2.446      41.039
ARABIA              0.476       0.011    0.257      0        1.221     112.1    1.289      1.993        18.041    1.585      27.699
SINGAPORE           0.808       0.013    4.234      6.784    5.761     12.631   10.1       8.291        42.103    3.467      86.478
THAILAND            0.719       0.135    2.717      3.532    2.395     7.316    7.696      35.1         15.201    5.268      53.631
US                  4.364       8.272    10.551     1.619    21.596    24.616   26.879     33.027       2258.6    47.581     349.072
VIETNAM             0.502       0.117    1.158      0.138    1.392     1.309    5.319      10.702       9.343     66.2       48.208
ROW                 3.409       4.203    11.648     9.478    128.771   51.284   212.527    28.84        344.554   28.202     612.6   ;

TABLE ENDW(R,F)
                     K                L
AUSTRALIA            344.1            1089.8
BAHRAIN              12.1             25.6
BRAZIL               280.3            1588.3
BRUNEI               5.6              8.0
CANADA               394.1            1319.2
CHILE                68.6             229.6
CHINA                5987.6           7620.6
EU                   3937.2           14811.4
INDIA                842.8            1875.9
INDONESIA            364.8            677.4
JAPAN                1193.1           3778.2
KOREA                485.8            1133.6
KUWAIT               35.2             105.4
MALAYSIA             86.1             272.5
MEXICO               280.8            939.9
NEWZEALAND           49.2             155.7
PERU                 46.6             175.5
PHILIPPINE           89.3             241.6
QATAR                82.3             109.1
RUSSIAN              381.2            1276.4
ARABIA               188.8            597.7
SINGAPORE            179.3            484.9
THAILAND             126.2            378.7
US                   4314.3           16230.0
VIETNAM              114.8            310.4
ROW                  2655.4           8408.7   ;

TABLE TARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.025    0.025   0.025   0.025   0.025  0.025  0.025  0.025  0.025      0.025  0.025  0.025   0.025     0.025
BAHRAIN             0.053      0        0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
BRAZIL              0.134      0.134    0       0.134   0.134   0.134  0.134  0.134  0.134  0.134      0.134  0.134  0.134   0.134     0.134
BRUNEI              0.321      0.321    0.321   0       0.321   0.321  0.321  0.321  0.321  0.321      0.321  0.321  0.321   0.321     0.321
CANADA              0.040      0.040    0.040   0.040   0       0.040  0.040  0.040  0.040  0.040      0.040  0.040  0.040   0.040     0.040
CHILE               0.060      0.060    0.060   0.060   0.060   0      0.060  0.060  0.060  0.060      0.060  0.060  0.060   0.060     0.060
CHINA               0.098      0.098    0.098   0.098   0.098   0.098  0      0.098  0.098  0.098      0.098  0.098  0.098   0.098     0.098
EU                  0.052      0.052    0.052   0.052   0.052   0.052  0.052  0      0.052  0.052      0.052  0.052  0.052   0.052     0.052
INDIA               0.171      0.171    0.171   0.171   0.171   0.171  0.171  0.171  0      0.171      0.171  0.171  0.171   0.171     0.171
INDONESIA           0.081      0.081    0.081   0.081   0.081   0.081  0.081  0.081  0.081  0          0.081  0.081  0.081   0.081     0.081
JAPAN               0.044      0.044    0.044   0.044   0.044   0.044  0.044  0.044  0.044  0.044      0      0.044  0.044   0.044     0.044
KOREA               0.137      0.137    0.137   0.137   0.137   0.137  0.137  0.137  0.137  0.137      0.137  0      0.137   0.137     0.137
KUWAIT              0.047      0.047    0.047   0.047   0.047   0.047  0.047  0.047  0.047  0.047      0.047  0.047  0       0.047     0.047
MALAYSIA            0.056      0.056    0.056   0.056   0.056   0.056  0.056  0.056  0.056  0.056      0.056  0.056  0.056   0         0.056
MEXICO              0.070      0.070    0.070   0.070   0.070   0.070  0.070  0.070  0.070  0.070      0.070  0.070  0.070   0.070     0
NEWZEALAND          0.020      0.020    0.020   0.020   0.020   0.020  0.020  0.020  0.020  0.020      0.020  0.020  0.020   0.020     0.020
PERU                0.024      0.024    0.024   0.024   0.024   0.024  0.024  0.024  0.024  0.024      0.024  0.024  0.024   0.024     0.024
PHILIPPINE          0.062      0.062    0.062   0.062   0.062   0.062  0.062  0.062  0.062  0.062      0.062  0.062  0.062   0.062     0.062
QATAR               0.048      0.048    0.048   0.048   0.048   0.048  0.048  0.048  0.048  0.048      0.048  0.048  0.048   0.048     0.048
RUSSIAN             0.068      0.068    0.068   0.068   0.068   0.068  0.068  0.068  0.068  0.068      0.068  0.068  0.068   0.068     0.068
ARABIA              0.053      0.053    0.053   0.053   0.053   0.053  0.053  0.053  0.053  0.053      0.053  0.053  0.053   0.053     0.053
SINGAPORE           0.001      0.001    0.001   0.001   0.001   0.001  0.001  0.001  0.001  0.001      0.001  0.001  0.001   0.001     0.001
THAILAND            0.096      0.096    0.096   0.096   0.096   0.096  0.096  0.096  0.096  0.096      0.096  0.096  0.096   0.096     0.096
US                  0.035      0.035    0.035   0.035   0.035   0.035  0.035  0.035  0.035  0.035      0.035  0.035  0.035   0.035     0.035
VIETNAM             0.095      0.095    0.095   0.095   0.095   0.095  0.095  0.095  0.095  0.095      0.095  0.095  0.095   0.095     0.095
ROW                 0.061      0.061    0.061   0.061   0.061   0.061  0.061  0.061  0.061  0.061      0.061  0.061  0.061   0.061     0.061

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR    RUSSIAN  ARABIA  SINGAPORE  THAILAND   US      VIETNAM  ROW
AUSTRALIA           0.025       0.025    0.025       0.025    0.025    0.025   0.025      0.025      0.025   0.025    0.025
BAHRAIN             0.053       0.053    0.053       0.053    0.053    0.053   0.053      0.053      0.053   0.053    0.053
BRAZIL              0.134       0.134    0.134       0.134    0.134    0.134   0.134      0.134      0.134   0.134    0.134
BRUNEI              0.321       0.321    0.321       0.321    0.321    0.321   0.321      0.321      0.321   0.321    0.321
CANADA              0.040       0.040    0.040       0.040    0.040    0.040   0.040      0.040      0.040   0.040    0.040
CHILE               0.060       0.060    0.060       0.060    0.060    0.060   0.060      0.060      0.060   0.060    0.060
CHINA               0.098       0.098    0.098       0.098    0.098    0.098   0.098      0.098      0.098   0.098    0.098
EU                  0.052       0.052    0.052       0.052    0.052    0.052   0.052      0.052      0.052   0.052    0.052
INDIA               0.171       0.171    0.171       0.171    0.171    0.171   0.171      0.171      0.171   0.171    0.171
INDONESIA           0.081       0.081    0.081       0.081    0.081    0.081   0.081      0.081      0.081   0.081    0.081
JAPAN               0.044       0.044    0.044       0.044    0.044    0.044   0.044      0.044      0.044   0.044    0.044
KOREA               0.137       0.137    0.137       0.137    0.137    0.137   0.137      0.137      0.137   0.137    0.137
KUWAIT              0.047       0.047    0.047       0.047    0.047    0.047   0.047      0.047      0.047   0.047    0.047
MALAYSIA            0.056       0.056    0.056       0.056    0.056    0.056   0.056      0.056      0.056   0.056    0.056
MEXICO              0.070       0.070    0.070       0.070    0.070    0.070   0.070      0.070      0.070   0.070    0.070
NEWZEALAND          0           0.020    0.020       0.020    0.020    0.020   0.020      0.020      0.020   0.020    0.020
PERU                0.024       0        0.024       0.024    0.024    0.024   0.024      0.024      0.024   0.024    0.024
PHILIPPINE          0.062       0.062    0           0.062    0.062    0.062   0.062      0.062      0.062   0.062    0.062
QATAR               0.048       0.048    0.048       0        0.048    0.048   0.048      0.048      0.048   0.048    0.048
RUSSIAN             0.068       0.068    0.068       0.068    0        0.068   0.068      0.068      0.068   0.068    0.068
ARABIA              0.053       0.053    0.053       0.053    0.053    0       0.053      0.053      0.053   0.053    0.053
SINGAPORE           0.001       0.001    0.001       0.001    0.001    0.001   0          0.001      0.001   0.001    0.001
THAILAND            0.096       0.096    0.096       0.096    0.096    0.096   0.096      0          0.096   0.096    0.096
US                  0.035       0.035    0.035       0.035    0.035    0.035   0.035      0.035      0       0.035    0.035
VIETNAM             0.095       0.095    0.095       0.095    0.095    0.095   0.095      0.095      0.095   0        0.095
ROW                 0.061       0.061    0.061       0.061    0.061    0.061   0.061      0.061      0.061   0.061    0       ;

TABLE NTARIFF(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU     INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0.855    1.045   0.622   0.692   0.785  0.292  0.508  0.523  0.592      0.354  0.227  0.915   0.225     0.836
BAHRAIN             0.827      0        0.845   0.006   0.897   0.006  0.668  0.513  0.410  1.020      0.572  0.385  0.474   0.435     1.227
BRAZIL              0.936      0.764    0       0.001   0.487   0.321  0.277  0.310  0.453  0.740      0.492  0.258  0.653   0.364     0.409
BRUNEI              0.644      0.251    0.251   0       0.251   0.251  0.560  1.059  0.251  0.631      0.522  0.344  0.251   0.261     0.251
CANADA              0.677      0.910    0.581   0.002   0       0.529  0.333  0.321  0.499  0.709      0.374  0.287  0.926   0.389     0.237
CHILE               0.750      0.000    0.395   0.000   0.509   0      0.320  0.421  0.509  1.057      0.478  0.252  0.000   0.588     0.451
CHINA               0.219      0.623    0.313   0.465   0.275   0.282  0      0.206  0.312  0.363      0.156  0.035  0.427   0.034     0.379
EU                  0.481      0.514    0.392   1.010   0.309   0.429  0.252  0      0.318  0.607      0.369  0.203  0.449   0.220     0.382
INDIA               0.377      0.292    0.416   0.036   0.368   0.398  0.239  0.199  0      0.290      0.343  0.131  0.148   0.027     0.381
INDONESIA           0.536      0.992    0.793   0.553   0.668   1.036  0.380  0.578  0.380  0          0.346  0.228  0.762   0.112     0.917
JAPAN               0.335      0.581    0.582   0.481   0.370   0.494  0.210  0.377  0.470  0.383      0      0.101  0.376   0.131     0.504
KOREA               0.115      0.301    0.255   0.210   0.190   0.175  0.002  0.118  0.165  0.172      0.008  0      0.075   0.026     0.219
KUWAIT              0.893      0.480    0.740   0.000   0.919   0.000  0.478  0.454  0.272  0.796      0.373  0.165  0       0.614     0.000
MALAYSIA            0.194      0.432    0.442   0.208   0.373   0.592  0.076  0.216  0.142  0.137      0.119  0.007  0.605   0         0.519
MEXICO              0.791      1.210    0.473   0.009   0.207   0.441  0.407  0.364  0.482  0.928      0.478  0.286  0.009   0.505     0
NEWZEALAND          0.280      0.000    1.188   0.602   0.688   1.008  0.494  0.588  0.746  0.772      0.546  0.388  0.000   0.312     0.888
PERU                1.376      0.010    0.655   0.010   0.590   0.445  0.571  0.672  0.778  1.402      0.753  0.468  0.010   0.901     0.671
PHILIPPINE          0.714      0.001    0.891   0.880   0.645   1.081  0.426  0.612  0.711  0.642      0.399  0.242  1.201   0.263     0.819
QATAR               0.651      0.306    0.668   0.001   0.749   1.084  0.423  0.308  0.227  0.701      0.225  0.079  0.585   0.311     0.880
RUSSIAN             0.973      0.029    0.699   0.029   0.754   1.047  0.341  0.141  0.593  0.837      0.414  0.237  0.029   0.560     0.867
ARABIA              0.877      0.226    0.574   0.005   0.567   1.113  0.309  0.308  0.166  0.558      0.300  0.091  0.494   0.367     0.839
SINGAPORE           0.191      0.379    0.502   0.208   0.427   0.818  0.129  0.199  0.129  0.094      0.198  0.012  0.812   0.161     0.482
THAILAND            0.057      0.168    0.285   0.115   0.228   0.346  0.048  0.097  0.081  0.074      0.042  0.049  0.453   0.019     0.255
US                  0.528      0.632    0.418   1.061   0.001   0.376  0.250  0.249  0.367  0.604      0.298  0.177  0.470   0.217     0.036
VIETNAM             0.254      0.000    0.440   0.388   0.351   0.477  0.065  0.205  0.155  0.306      0.101  0.014  0.656   0.033     0.533
ROW                 0.160      0.027    0.121   0.476   0.178   0.221  0.659  0.663  0.724  0.461      0.074  0.056  0.122   0.070     0.185

+
                    NEWZEALAND  PERU     PHILIPPINE  QATAR   RUSSIAN  ARABIA  SINGAPORE  THAILAND    US      VIETNAM  ROW
AUSTRALIA           0.275       1.375    0.751       0.674   1.016    0.905   0.166      0.128       0.538   0.324    0.196
BAHRAIN             0.006       0.006    0.006       0.301   0.006    0.226   0.326      0.211       0.614   0.094    0.135
BRAZIL              1.074       0.545    0.819       0.582   0.633    0.493   0.368      0.247       0.319   0.401    0.048
BRUNEI              0.619       0.251    0.939       0.251   0.251    0.251   0.305      0.308       1.093   0.480    0.534
CANADA              0.668       0.574    0.667       0.757   0.782    0.580   0.387      0.284       0.084   0.406    0.199
CHILE               0.968       0.409    1.083       1.072   1.055    1.106   0.758      0.382       0.351   0.512    0.222
CHINA               0.416       0.497    0.390       0.373   0.311    0.264   0.031      0.086       0.187   0.062    0.122
EU                  0.556       0.644    0.622       0.304   0.157    0.309   0.147      0.141       0.232   0.248    0.072
INDIA               0.595       0.631    0.602       0.104   0.490    0.048   0.012      0.006       0.231   0.079    0.048
INDONESIA           0.711       1.345    0.623       0.668   0.824    0.530   0.013      0.089       0.558   0.320    0.441
JAPAN               0.522       0.733    0.417       0.229   0.438    0.309   0.154      0.094       0.289   0.152    0.091
KOREA               0.271       0.355    0.167       0.020   0.168    0.007   0.075      0.008       0.075   0.072    0.080
KUWAIT              0.000       0.000    1.216       0.586   0.000    0.500   0.765      0.502       0.458   0.704    0.136
MALAYSIA            0.276       0.869    0.269       0.303   0.572    0.364   0.105      0.059       0.196   0.172    0.075
MEXICO              0.838       0.625    0.811       0.858   0.865    0.822   0.412      0.281       0.101   0.558    0.176
NEWZEALAND          0           1.165    0.763       0.706   0.927    0.645   0.274      0.259       0.599   0.452    0.296
PERU                1.161       0.000    1.277       0.010   1.151    1.495   1.115      0.549       0.529   1.086    0.354
PHILIPPINE          0.721       1.239    0.000       0.713   1.030    0.824   0.152      0.146       0.551   0.422    0.655
QATAR               0.678       0.001    0.727       0.000   1.185    0.365   0.070      0.078       0.493   0.411    0.160
RUSSIAN             0.879       1.107    1.024       1.165   0.000    0.961   0.497      0.345       0.512   0.379    0.060
ARABIA              0.612       1.466    0.833       0.360   0.976    0.000   0.260      0.272       0.313   0.368    0.099
SINGAPORE           0.294       1.139    0.214       0.118   0.565    0.313   0.000      0.128       0.196   0.008    0.168
THAILAND            0.183       0.477    0.112       0.030   0.317    0.229   0.032      0.000       0.085   0.137    0.093
US                  0.584       0.518    0.578       0.506   0.545    0.331   0.161      0.146       0.000   0.265    0.040
VIETNAM             0.377       1.015    0.389       0.364   0.352    0.326   0.013      0.038       0.205   0.000    0.539
ROW                 0.255       0.317    0.656       0.147   0.067    0.091   0.107      0.048       0.047   0.573    0.000  ;

TABLE RTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       1       1       1      1      1     1      1          1      1      1       1         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              1          1        1       0       1       1      1      1     1      1          1      1      1       1         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               1          1        1       1       1       1      0      1     1      1          1      1      1       1         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               1          1        1       1       1       1      1      1     0      1          1      1      1       1         1
INDONESIA           1          1        1       1       1       1      1      1     1      0          1      1      1       1         1
JAPAN               1          1        1       1       1       1      1      1     1      1          0      1      1       1         1
KOREA               1          1        1       1       1       1      1      1     1      1          1      0      1       1         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            1          1        1       1       1       1      1      1     1      1          1      1      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
THAILAND            1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           1           1     1           1      1         1       1          1         1   1        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              1           1     1           1      1         1       1          1         1   1        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               1           1     1           1      1         1       1          1         1   1        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               1           1     1           1      1         1       1          1         1   1        1
INDONESIA           1           1     1           1      1         1       1          1         1   1        1
JAPAN               1           1     1           1      1         1       1          1         1   1        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            1           1     1           1      1         1       1          1         1   1        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     1           1      1         1       1          1         1   1        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          1           1     0           1      1         1       1          1         1   1        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           1           1     1           1      1         1       0          1         1   1        1
THAILAND            1           1     1           1      1         1       1          0         1   1        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             1           1     1           1      1         1       1          1         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0  ;


TABLE FTA(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
BAHRAIN             1          0        1       1       1       1      1      1     1      1          1      1      1       1         1
BRAZIL              1          1        0       1       1       1      1      1     1      1          1      1      1       1         1
BRUNEI              0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
CANADA              1          1        1       1       0       1      1      1     1      1          1      1      1       1         1
CHILE               1          1        1       1       1       0      1      1     1      1          1      1      1       1         1
CHINA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
EU                  1          1        1       1       1       1      1      0     1      1          1      1      1       1         1
INDIA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
INDONESIA           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
JAPAN               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KOREA               0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
KUWAIT              1          1        1       1       1       1      1      1     1      1          1      1      0       1         1
MALAYSIA            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
MEXICO              1          1        1       1       1       1      1      1     1      1          1      1      1       1         0
NEWZEALAND          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
PERU                1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
PHILIPPINE          0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
QATAR               1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
RUSSIAN             1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
ARABIA              1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
SINGAPORE           0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
THAILAND            0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
US                  1          1        1       1       1       1      1      1     1      1          1      1      1       1         1
VIETNAM             0          1        1       0       1       1      0      1     0      0          0      0      1       0         1
ROW                 1          1        1       1       1       1      1      1     1      1          1      1      1       1         1

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           1     0           1      1         1       0          0         1   0        1
BAHRAIN             1           1     1           1      1         1       1          1         1   1        1
BRAZIL              1           1     1           1      1         1       1          1         1   1        1
BRUNEI              0           1     0           1      1         1       0          0         1   0        1
CANADA              1           1     1           1      1         1       1          1         1   1        1
CHILE               1           1     1           1      1         1       1          1         1   1        1
CHINA               0           1     0           1      1         1       0          0         1   0        1
EU                  1           1     1           1      1         1       1          1         1   1        1
INDIA               0           1     0           1      1         1       0          0         1   0        1
INDONESIA           0           1     0           1      1         1       0          0         1   0        1
JAPAN               0           1     0           1      1         1       0          0         1   0        1
KOREA               0           1     0           1      1         1       0          0         1   0        1
KUWAIT              1           1     1           1      1         1       1          1         1   1        1
MALAYSIA            0           1     0           1      1         1       0          0         1   0        1
MEXICO              1           1     1           1      1         1       1          1         1   1        1
NEWZEALAND          0           1     0           1      1         1       0          0         1   0        1
PERU                1           0     1           1      1         1       1          1         1   1        1
PHILIPPINE          0           1     0           1      1         1       0          0         1   0        1
QATAR               1           1     1           0      1         1       1          1         1   1        1
RUSSIAN             1           1     1           1      0         1       1          1         1   1        1
ARABIA              1           1     1           1      1         0       1          1         1   1        1
SINGAPORE           0           1     0           1      1         1       0          0         1   0        1
THAILAND            0           1     0           1      1         1       0          0         1   0        1
US                  1           1     1           1      1         1       1          1         0   1        1
VIETNAM             0           1     0           1      1         1       0          0         1   0        1
ROW                 1           1     1           1      1         1       1          1         1   1        0   ;


TABLE WAR(R,RR)

                    AUSTRALIA  BAHRAIN  BRAZIL  BRUNEI  CANADA  CHILE  CHINA  EU    INDIA  INDONESIA  JAPAN  KOREA  KUWAIT  MALAYSIA  MEXICO
AUSTRALIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BAHRAIN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRAZIL              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
BRUNEI              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CANADA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHILE               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
CHINA               0          0        0       0       0       0      0      1     0      0          1      0      0       0         0
EU                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
INDIA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
INDONESIA           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
JAPAN               0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
KOREA               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
KUWAIT              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MALAYSIA            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
MEXICO              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
NEWZEALAND          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PERU                0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
PHILIPPINE          0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
QATAR               0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
RUSSIAN             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ARABIA              0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
SINGAPORE           0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
THAILAND            0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
US                  0          0        0       0       0       0      1      0     0      0          0      0      0       0         0
VIETNAM             0          0        0       0       0       0      0      0     0      0          0      0      0       0         0
ROW                 0          0        0       0       0       0      0      0     0      0          0      0      0       0         0

+
                    NEWZEALAND  PERU  PHILIPPINE  QATAR  RUSSIAN   ARABIA  SINGAPORE  THAILAND  US  VIETNAM  ROW
AUSTRALIA           0           0     0           0      0         0       0          0         0   0        0
BAHRAIN             0           0     0           0      0         0       0          0         0   0        0
BRAZIL              0           0     0           0      0         0       0          0         0   0        0
BRUNEI              0           0     0           0      0         0       0          0         0   0        0
CANADA              0           0     0           0      0         0       0          0         0   0        0
CHILE               0           0     0           0      0         0       0          0         0   0        0
CHINA               0           0     0           0      0         0       0          0         1   0        0
EU                  0           0     0           0      0         0       0          0         0   0        0
INDIA               0           0     0           0      0         0       0          0         0   0        0
INDONESIA           0           0     0           0      0         0       0          0         0   0        0
JAPAN               0           0     0           0      0         0       0          0         0   0        0
KOREA               0           0     0           0      0         0       0          0         0   0        0
KUWAIT              0           0     0           0      0         0       0          0         0   0        0
MALAYSIA            0           0     0           0      0         0       0          0         0   0        0
MEXICO              0           0     0           0      0         0       0          0         0   0        0
NEWZEALAND          0           0     0           0      0         0       0          0         0   0        0
PERU                0           0     0           0      0         0       0          0         0   0        0
PHILIPPINE          0           0     0           0      0         0       0          0         0   0        0
QATAR               0           0     0           0      0         0       0          0         0   0        0
RUSSIAN             0           0     0           0      0         0       0          0         0   0        0
ARABIA              0           0     0           0      0         0       0          0         0   0        0
SINGAPORE           0           0     0           0      0         0       0          0         0   0        0
THAILAND            0           0     0           0      0         0       0          0         0   0        0
US                  0           0     0           0      0         0       0          0         0   0        0
VIETNAM             0           0     0           0      0         0       0          0         0   0        0
ROW                 0           0     0           0      0         0       0          0         0   0        0   ;




***************CALIBRATION**************
PARAMETERS

DISTN(R,G,F)      SHARE PARAMETER IN PRODUCTION FUNCTION
SCALE(R,G)        SCALE PAREMETER IN PRODUCTION

SHARE1(R)         SHARE PARAMETER OF COMPOSITE TRADABLE GOODS
SHARE2(R)         SHARE PARAMETER OF NONTRADABLE GOODS
SHARE3(R)         SHARE PARAMETER OF INSIDE MONEY
SHARE4(R,RR)      SHARE PARAMETER OF TRADABLE GOODS
PM1(R)            PRICE FOR COMPOSITE TRADABLE GOODS

ELASC1(R)         FIRST LEVEL CONSUMPTION ELASTICITY OF SUBSITUTION
ELASC2(R)         SECOND LEVEL CONSUMPTION ELASTICITY OF SUBSTITUTION
ELASP(R,G)        PRODUCTION ELASTICITY OF SUBSITUTION
;


ELASC1(R) = ELASC10(R)*1.5;
ELASC2(R) = ELASC20(R)*1.5;
ELASP(R,G) = ELASP0(R,G)*1.5;

DISTN(R,G,F) = ((FACDEM1(R,G,F)**(1/ELASP(R,G))))/SUM(FF,(FACDEM1(R,G,FF)**(1/ELASP(R,G))));
SCALE(R,G) = PRN1(R,G)/(SUM(F,DISTN(R,G,F)*(FACDEM1(R,G,F)**((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1)));

SHARE4(R,RR) = GDEM1(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**ELASC2(R))/SUM(RRR,GDEM1(R,RRR)*((1+TARIFF(R,RRR)+NTARIFF(R,RRR))**ELASC2(R)));
PM1(R) = (SUM(RR,SHARE4(R,RR)*((1+TARIFF(R,RR)+NTARIFF(R,RR))**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));
SHARE1(R) = TGDEM1(R)*(PM1(R)**ELASC1(R))/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE2(R) = NGDEM1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));
SHARE3(R) = MONEY1(R)/(TGDEM1(R)*(PM1(R)**ELASC1(R))+MONEY1(R)+NGDEM1(R));

DISPLAY DISTN,SCALE,PM1,SHARE1,SHARE2,SHARE3,SHARE4,ELASC1,ELASC2,ELASP;


********************MODEL SYSTEM********************
VARIABLES
PRN(R,G)            PRODUCTION OF SECTORS
FACDEM(R,G,F)       FACTOR DEMAND BY GOODS

TGDEM(R)            TRADABLE COMPOSITE GOODS
NGDEM(R)            NONTRADABLE GOODS
MONEY(R)            INSIDE MONEY
GDEM(R,RR)          TRADABLE GOODS DEMAND

P(R,G)              PRICE OF PRODUCTION
PRCT(R,RR)          PRICE OF TRADABLE GOODS
PRCN(R)             PRICE OF NON-TRADABLE GOODS
PRCM(R)             PRICE OF INSIDE MONEY
PM(R)               PRICE OF COMPOSITE TRADABLE GOODS
W(R,F)              WAGES BY FACTORS

SURPLUS(R)          TRADE IMBALANCE DENOTED BY INSIDE MONEY
REV(R)              REVENUE COLLECTION
NREV(R)             COSTS FOR SOLVING NON-TARIFF TRADE COSTS
INC(R)              INCOME BY INDIVIDUAL

Z(R)                EXCESS DEMAND OF TRADABLE GOODS
DMY                 A DUMMY OBJECTIVE VARIABLE

EQUATIONS
PRNDEF(R,G)         DEFINITION OF PRODUCTION FUNCTION
FACDEMDEF(R,G,F)    DEFINITION OF FACTOR DEMAND

TGDEMDEF(R)         DEFINITION OF TRADABLE COMPOSITE GOODS
NGDEMDEF(R)         DEFINITION OF NON-TRADABLE GOODS
MONEYDEF(R)         DEFINITION OF INSIDE MONEY
GDEMDEF(R,RR)       DEFINITION OF TRADABLE GOODS DEMAND

PRCTDEF(R,RR)       DEFINITION OF TRADABLE GOODS CONSUMER PRICE
PRCNDEF(R)          DEFINITION OF NONTRADABLE GOODS CONSUMER PRICE
PMDEF(R)            DEFINITION OF AMINGTON PRICES

SURPLUSDEF(R)       DEFINITION OF TRADE IMBALANCE DENOTED BY INSIDE MONEY
REVDEF(R)           DEFINITION OF REVENUE COLLECTION
NREVDEF(R)          DEFINITION OF COSTS FOR SLOVING NON-TARIFF BARRIERS
INCDEF(R)           INCOME DEFINITION

FACDEF(R,F)         DEFINITION OF FACTOR CLEARANCE
ZPROF(R,G)          ZERO PROFIT CONDITION
SDEF                SURPLUS CLEARANCE DEFINITION
NGDEF(R)            NONTRADABLE GOODS CLEARANCE CONDITION
TGDEF(R)            TRADABLE GOODS CLEARANCE CONDITION

DMYOBJ              DEFINITION OF DUMMY OBJECTIVE FUNCTION
;

PRNDEF(R,G)..
PRN(R,G) =E= SCALE(R,G)*SUM(F,DISTN(R,G,F)*(FACDEM(R,G,F)**
((ELASP(R,G)-1)/ELASP(R,G))))**(ELASP(R,G)/(ELASP(R,G)-1));

FACDEMDEF(R,G,F)..
FACDEM(R,G,F) =E= (1/SCALE(R,G))*PRN(R,G)*(DISTN(R,G,F)+((SUM(FF,DISTN(R,G,FF))
-DISTN(R,G,F))*((DISTN(R,G,F)*(SUM(FF,W(R,FF))-W(R,F)))/((SUM(FF,DISTN(R,G,FF))-DISTN(R,G,F))*W(R,F)))**
(1-ELASP(R,G))))**(ELASP(R,G)/(1-ELASP(R,G)));

TGDEMDEF(R)..
TGDEM(R) =E= (SHARE1(R)*INC(R))/((PM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

NGDEMDEF(R)..
NGDEM(R) =E= (SHARE2(R)*INC(R))/((PRCN(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

MONEYDEF(R)..
MONEY(R) =E= (SHARE3(R)*INC(R))/((PRCM(R)**ELASC1(R))*(SHARE1(R)*(PM(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN(R)**
(1-ELASC1(R)))+SHARE3(R)*(PRCM(R)**(1-ELASC1(R)))));

GDEMDEF(R,RR)..
GDEM(R,RR) =E= (SHARE4(R,RR)*PM(R)*TGDEM(R))/((PRCT(R,RR)**ELASC2(R))*SUM(RRR,SHARE4(R,RRR)*(PRCT(R,RRR)**(1-ELASC2(R)))));

PRCTDEF(R,RR)..
PRCT(R,RR) =E= P(RR,"TRADABLE")*(1+TARIFF(R,RR)+200*WAR(R,RR)+NTARIFF(R,RR));

PRCNDEF(R)..
PRCN(R) =E= P(R,"NONTRADABLE");

PMDEF(R)..
PM(R) =E= (SUM(RR,SHARE4(R,RR)*(PRCT(R,RR)**(1-ELASC2(R)))))**(1/(1-ELASC2(R)));

SURPLUSDEF(R)..
SURPLUS(R) =E= MONEY(R)-1000;

REVDEF(R)..
REV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*(TARIFF(R,RR)+200*WAR(R,RR)));

NREVDEF(R)..
NREV(R) =E= SUM(RR,GDEM(R,RR)*P(RR,"TRADABLE")*(NTARIFF(R,RR)+200*WAR(R,RR)));

INCDEF(R)..
INC(R) =E= SUM(FF,ENDW(R,FF)*W(R,FF))+REV(R)+1000;

FACDEF(R,F)..
ENDW(R,F) =E= SUM(G,FACDEM(R,G,F));

ZPROF(R,G)..
PRN(R,G)*P(R,G) =E= SUM(F,FACDEM(R,G,F)*W(R,F));

SDEF..
SUM(R,SURPLUS(R)) =E= 0;

NGDEF(R)..
NGDEM(R) =E= PRN(R,"NONTRADABLE")-(NREV(R)/PRCN(R));

TGDEF(R)..
Z(R) =E= SUM(RR,GDEM(RR,R))-PRN(R,"TRADABLE");

DMYOBJ..
DMY =E= SUM(R,P(R,"TRADABLE")*Z(R)*P(R,"TRADABLE")*Z(R))/10000;

MODEL CHUNDING /ALL/;

PRN.LO(R,G)=0.1;
PRN.LO("AUSTRALIA",G)=100;
PRN.LO("BAHRAIN",G)=2;
PRN.LO("BRAZIL",G)=100;
PRN.LO("BRUNEI",G)=1;
PRN.LO("CANADA",G)=100;
PRN.LO("CHILE",G)=10;
PRN.LO("CHINA",G)=1000;
PRN.LO("EU",G)=1000;
PRN.LO("INDIA",G)=100;
PRN.LO("INDONESIA",G)=50;
PRN.LO("JAPAN",G)=100;
PRN.LO("KOREA",G)=60;
PRN.LO("KUWAIT",G)=1;
PRN.LO("MALAYSIA",G)=10;
PRN.LO("MEXICO",G)=50;
PRN.LO("NEWZEALAND",G)=2;
PRN.LO("PERU",G)=10;
PRN.LO("PHILIPPINE",G)=10;
PRN.LO("QATAR",G)=6;
PRN.LO("RUSSIAN",G)=100;
PRN.LO("ARABIA",G)=10;
PRN.LO("SINGAPORE",G)=100;
PRN.LO("THAILAND",G)=5;
PRN.LO("US",G)=100;
PRN.LO("VIETNAM",G)=10;
PRN.LO("ROW",G)=500;

FACDEM.LO(R,G,F)=0.1;
FACDEM.LO("AUSTRALIA",G,F)=60;
FACDEM.LO("BAHRAIN",G,F)=1;
FACDEM.LO("BRAZIL",G,F)=10;
FACDEM.LO("BRUNEI",G,F)=0.1;
FACDEM.LO("CANADA",G,F)=20;
FACDEM.LO("CHILE",G,F)=5;
FACDEM.LO("CHINA",G,F)=600;
FACDEM.LO("EU",G,F)=600;
FACDEM.LO("INDIA",G,F)=20;
FACDEM.LO("INDONESIA",G,F)=30;
FACDEM.LO("JAPAN",G,F)=60;
FACDEM.LO("KOREA",G,F)=50;
FACDEM.LO("KUWAIT",G,F)=1;
FACDEM.LO("MALAYSIA",G,F)=10;
FACDEM.LO("MEXICO",G,F)=20;
FACDEM.LO("NEWZEALAND",G,F)=2;
FACDEM.LO("PERU",G,F)=5;
FACDEM.LO("PHILIPPINE",G,F)=6;
FACDEM.LO("QATAR",G,F)=3;
FACDEM.LO("RUSSIAN",G,F)=20;
FACDEM.LO("ARABIA",G,F)=20;
FACDEM.LO("SINGAPORE",G,F)=5;
FACDEM.LO("THAILAND",G,F)=2;
FACDEM.LO("US",G,F)=100;
FACDEM.LO("VIETNAM",G,F)=2;
FACDEM.LO("ROW",G,F)=200;

TGDEM.LO(R)=0.1;
TGDEM.LO("AUSTRALIA")=100;
TGDEM.LO("BAHRAIN")=2;
TGDEM.LO("BRAZIL")=60;
TGDEM.LO("BRUNEI")=1;
TGDEM.LO("CANADA")=100;
TGDEM.LO("CHILE")=10;
TGDEM.LO("CHINA")=1000;
TGDEM.LO("EU")=1000;
TGDEM.LO("INDIA")=100;
TGDEM.LO("INDONESIA")=60;
TGDEM.LO("JAPAN")=300;
TGDEM.LO("KOREA")=100;
TGDEM.LO("KUWAIT")=5;
TGDEM.LO("MALAYSIA")=50;
TGDEM.LO("MEXICO")=100;
TGDEM.LO("NEWZEALAND")=10;
TGDEM.LO("PERU")=10;
TGDEM.LO("PHILIPPINE")=20;
TGDEM.LO("QATAR")=5;
TGDEM.LO("RUSSIAN")=100;
TGDEM.LO("ARABIA")=60;
TGDEM.LO("SINGAPORE")=60;
TGDEM.LO("THAILAND")=60;
TGDEM.LO("US")=1000;
TGDEM.LO("VIETNAM")=20;
TGDEM.LO("ROW")=1000;

NGDEM.LO(R)=0.1;
NGDEM.LO("AUSTRALIA")=100;
NGDEM.LO("BAHRAIN")=1;
NGDEM.LO("BRAZIL")=100;
NGDEM.LO("BRUNEI")=1;
NGDEM.LO("CANADA")=500;
NGDEM.LO("CHILE")=10;
NGDEM.LO("CHINA")=1000;
NGDEM.LO("EU")=1000;
NGDEM.LO("INDIA")=500;
NGDEM.LO("INDONESIA")=60;
NGDEM.LO("JAPAN")=600;
NGDEM.LO("KOREA")=100;
NGDEM.LO("KUWAIT")=5;
NGDEM.LO("MALAYSIA")=10;
NGDEM.LO("MEXICO")=100;
NGDEM.LO("NEWZEALAND")=10;
NGDEM.LO("PERU")=10;
NGDEM.LO("PHILIPPINE")=20;
NGDEM.LO("QATAR")=5;
NGDEM.LO("RUSSIAN")=100;
NGDEM.LO("ARABIA")=20;
NGDEM.LO("SINGAPORE")=60;
NGDEM.LO("THAILAND")=10;
NGDEM.LO("US")=1000;
NGDEM.LO("VIETNAM")=10;
NGDEM.LO("ROW")=500;

MONEY.LO(R)=100;
MONEY.LO("AUSTRALIA")=800;
MONEY.LO("BAHRAIN")=800;
MONEY.LO("BRAZIL")=800;
MONEY.LO("BRUNEI")=800;
MONEY.LO("CANADA")=600;
MONEY.LO("CHILE")=600;
MONEY.LO("CHINA")=900;
MONEY.LO("EU")=800;
MONEY.LO("INDIA")=500;
MONEY.LO("INDONESIA")=600;
MONEY.LO("JAPAN")=500;
MONEY.LO("KOREA")=800;
MONEY.LO("KUWAIT")=800;
MONEY.LO("MALAYSIA")=800;
MONEY.LO("MEXICO")=600;
MONEY.LO("NEWZEALAND")=600;
MONEY.LO("PERU")=600;
MONEY.LO("PHILIPPINE")=600;
MONEY.LO("QATAR")=800;
MONEY.LO("RUSSIAN")=900;
MONEY.LO("ARABIA")=900;
MONEY.LO("SINGAPORE")=800;
MONEY.LO("THAILAND")=600;
MONEY.LO("US")=100;
MONEY.LO("VIETNAM")=600;
MONEY.LO("ROW")=800;

REV.LO(R)=0.05;
REV.LO("AUSTRALIA")=2;
REV.LO("BAHRAIN")=0.1;
REV.LO("BRAZIL")=6;
REV.LO("BRUNEI")=0.2;
REV.LO("CANADA")=6;
REV.LO("CHILE")=2;
REV.LO("CHINA")=60;
REV.LO("EU")=20;
REV.LO("INDIA")=10;
REV.LO("INDONESIA")=3;
REV.LO("JAPAN")=10;
REV.LO("KOREA")=10;
REV.LO("KUWAIT")=0.2;
REV.LO("MALAYSIA")=2;
REV.LO("MEXICO")=2;
REV.LO("NEWZEALAND")=0.2;
REV.LO("PERU")=0.3;
REV.LO("PHILIPPINE")=1;
REV.LO("QATAR")=0.2;
REV.LO("RUSSIAN")=2;
REV.LO("ARABIA")=2;
REV.LO("SINGAPORE")=0.1;
REV.LO("THAILAND")=2;
REV.LO("US")=10;
REV.LO("VIETNAM")=2;
REV.LO("ROW")=50;

NREV.LO(R)=0.1;
NREV.LO("AUSTRALIA")=10;
NREV.LO("BAHRAIN")=1;
NREV.LO("BRAZIL")=6;
NREV.LO("BRUNEI")=0.2;
NREV.LO("CANADA")=6;
NREV.LO("CHILE")=2;
NREV.LO("CHINA")=60;
NREV.LO("EU")=20;
NREV.LO("INDIA")=10;
NREV.LO("INDONESIA")=10;
NREV.LO("JAPAN")=50;
NREV.LO("KOREA")=10;
NREV.LO("KUWAIT")=2;
NREV.LO("MALAYSIA")=2;
NREV.LO("MEXICO")=10;
NREV.LO("NEWZEALAND")=2;
NREV.LO("PERU")=3;
NREV.LO("PHILIPPINE")=5;
NREV.LO("QATAR")=1;
NREV.LO("RUSSIAN")=10;
NREV.LO("ARABIA")=6;
NREV.LO("SINGAPORE")=10;
NREV.LO("THAILAND")=2;
NREV.LO("US")=60;
NREV.LO("VIETNAM")=2;
NREV.LO("ROW")=100;

INC.LO(R)=1;
INC.LO("AUSTRALIA")=600;
INC.LO("BAHRAIN")=10;
INC.LO("BRAZIL")=600;
INC.LO("BRUNEI")=2;
INC.LO("CANADA")=600;
INC.LO("CHILE")=60;
INC.LO("CHINA")=1000;
INC.LO("EU")=2000;
INC.LO("INDIA")=500;
INC.LO("INDONESIA")=100;
INC.LO("JAPAN")=500;
INC.LO("KOREA")=100;
INC.LO("KUWAIT")=10;
INC.LO("MALAYSIA")=60;
INC.LO("MEXICO")=100;
INC.LO("NEWZEALAND")=20;
INC.LO("PERU")=50;
INC.LO("PHILIPPINE")=60;
INC.LO("QATAR")=10;
INC.LO("RUSSIAN")=500;
INC.LO("ARABIA")=100;
INC.LO("SINGAPORE")=100;
INC.LO("THAILAND")=100;
INC.LO("US")=1000;
INC.LO("VIETNAM")=10;
INC.LO("ROW")=1000;

*GDEM.LO(R,RR)=0.1;

P.LO(R,G)=0.3;
PRCT.LO(R,RR)=0.4;
PRCN.LO(R)=0.4;
PM.LO(R)=0.4;
W.LO(R,F)=0.3;
PRCM.FX(R)=1;
W.FX("ARABIA","L")=1;

SOLVE CHUNDING USING NLP MINIMIZING DMY;

DISPLAY PRN.L, FACDEM.L, TGDEM.L, NGDEM.L, MONEY.L, GDEM.L, P.L, PRCT.L, PRCN.L, PM.L, W.L, SURPLUS.L, REV.L, INC.L;


***************SPECIFIC CALCULATION******************
PARAMETERS

PRODUCTION0(R)
/AUSTRALIA   1196.893,    BAHRAIN       22.579,    BRAZIL      1667.286
BRUNEI         6.798,    CANADA      2337.979,    CHILE        222.676
CHINA      15955.372,    EU         22870.713,    INDIA       2775.004
INDONESIA    803.450,    JAPAN       5359.746,    KOREA       1684.878
KUWAIT        70.300,    MALAYSIA     299.764,    MEXICO      1781.715
NEWZEALAND   156.544,    PERU         162.250,    PHILIPPINE   220.317
QATAR         95.700,    RUSSIAN     1616.535,    ARABIA       786.500
SINGAPORE    712.535,    THAILAND     441.237,    US         32010.983
VIETNAM      416.894,    ROW         8667.480/,


EXPORT0(R)        TOTAL EXPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   327.624,    BAHRAIN      26.724,    BRAZIL      354.812
BRUNEI       10.137,    CANADA      658.810,    CHILE       114.800
CHINA      3308.169,    EU         3233.111,    INDIA       487.075
INDONESIA   258.523,    JAPAN       967.136,    KOREA       777.124
KUWAIT      128.998,    MALAYSIA    344.650,    MEXICO      657.883
NEWZEALAND   57.185,    PERU         76.128,    PHILIPPINE  113.440
QATAR       141.955,    RUSSIAN     656.421,    ARABIA      384.582
SINGAPORE   596.692,    THAILAND    348.807,    US         1790.454
VIETNAM     338.385,    ROW        4137.055/,

IMPORT0(R)        TOTAL IMPORT OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   204.015,    BAHRAIN      20.800,    BRAZIL      161.251
BRUNEI        4.270,    CANADA      554.117,    CHILE        66.277
CHINA      2712.922,    EU         3108.532,    INDIA       540.731
INDONESIA   159.926,    JAPAN       828.144,    KOREA       555.946
KUWAIT       33.517,    MALAYSIA    207.078,    MEXICO      569.212
NEWZEALAND   41.591,    PERU         40.033,    PHILIPPINE  104.612
QATAR        26.908,    RUSSIAN     230.432,    ARABIA      133.631
SINGAPORE   388.209,    THAILAND    238.779,    US         4645.440
VIETNAM     238.504,    ROW        4481.801/,

BALANCE0(R)       TOTAL IMBALNCE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA    123.609,    BAHRAIN        5.924,    BRAZIL       193.561
BRUNEI         5.867,    CANADA       104.693,    CHILE         48.523
CHINA        595.246,    EU           124.578,    INDIA        -53.656
INDONESIA     98.596,    JAPAN        138.992,    KOREA        221.178
KUWAIT        95.480,    MALAYSIA     137.572,    MEXICO        88.671
NEWZEALAND    15.594,    PERU          36.095,    PHILIPPINE     8.829
QATAR        115.046,    RUSSIAN      425.990,    ARABIA       250.951
SINGAPORE    208.483,    THAILAND     110.028,    US         -2854.986
VIETNAM       99.881,    ROW         -344.746/,

TRADE0(R)         TOTAL TRADE OF ONE COUNTRY IN BASE CASE
/AUSTRALIA   531.639,    BAHRAIN      47.524,    BRAZIL      516.063
BRUNEI       14.407,    CANADA     1212.927,    CHILE       181.077
CHINA      6021.091,    EU         6341.643,    INDIA      1027.805
INDONESIA   418.449,    JAPAN      1795.279,    KOREA      1333.071
KUWAIT      162.515,    MALAYSIA    551.728,    MEXICO     1227.095
NEWZEALAND   98.776,    PERU        116.161,    PHILIPPINE  218.052
QATAR       168.863,    RUSSIAN     886.853,    ARABIA      518.212
SINGAPORE   984.902,    THAILAND    587.586,    US         6435.895
VIETNAM     576.889,    ROW        8618.856/,

NGDEM0(R)       NON-TRADABLE GOODS DEMAND IN BASE CASE
/AUSTRALIA   1102.610,    BAHRAIN       21.364,    BRAZIL      1486.426
BRUNEI         6.448,    CANADA       727.534,    CHILE        245.158
CHINA       6456.663,    EU         13500.879,    INDIA       1489.723
INDONESIA    525.826,    JAPAN       3187.621,    KOREA        759.904
KUWAIT       112.052,    MALAYSIA      83.243,    MEXICO       375.413
NEWZEALAND   171.956,    PERU         167.330,    PHILIPPINE   234.547
QATAR        157.465,    RUSSIAN     1034.422,    ARABIA       342.402
SINGAPORE    161.697,    THAILAND     228.658,    US         15476.808
VIETNAM       72.823,    ROW         1509.856/,

UTILITY0(R)     TOTAL UTILITY IN BASE CASE
/AUSTRALIA    817.181,    BAHRAIN        2.377,    BRAZIL      1143.369
BRUNEI         0.211,    CANADA       988.557,    CHILE         75.697
CHINA      12149.555,    EU         17789.172,    INDIA       2269.529
INDONESIA    568.850,    JAPAN       4022.720,    KOREA        939.882
KUWAIT        13.631,    MALAYSIA      82.061,    MEXICO       618.205
NEWZEALAND    41.453,    PERU          45.066,    PHILIPPINE   124.040
QATAR         24.228,    RUSSIAN      763.901,    ARABIA       215.348
SINGAPORE    230.487,    THAILAND     180.723,    US         21699.990
VIETNAM      131.418,    ROW         5836.943/,

PRCN0(R)       CONSUMPTION PICE OF NON-TRADABLE GOODS IN BASE CASE
/AUSTRALIA  0.835,    BAHRAIN    0.599,    BRAZIL     0.892,    BRUNEI     0.500
CANADA     1.365,    CHILE      0.747,    CHINA      1.172,    EU         1.220
INDIA      1.021,    INDONESIA  0.771,    JAPAN      1.078,    KOREA      1.040
KUWAIT     0.500,    MALAYSIA   0.836,    MEXICO     1.460,    NEWZEALAND 0.764
PERU       0.731,    PHILIPPINE 0.666,    QATAR      0.500,    RUSSIAN    0.975
ARABIA     1.000,    SINGAPORE  1.073,    THAILAND   0.874,    US         1.554
VIETNAM    0.980,    ROW        0.783/,

EMPLOYMENT0(R)
/AUSTRALIA   190.107,    BAHRAIN       2.077,    BRAZIL      282.747
BRUNEI        1.221,    CANADA      693.559,    CHILE        16.670
CHINA      3791.723,    EU         3768.710,    INDIA       796.152
INDONESIA   288.163,    JAPAN      1213.909,    KOREA       576.442
KUWAIT        3.654,    MALAYSIA    185.638,    MEXICO      575.545
NEWZEALAND    6.332,    PERU         18.825,    PHILIPPINE   16.263
QATAR         8.283,    RUSSIAN     436.358,    ARABIA      309.869
SINGAPORE   318.351,    THAILAND    190.853,    US         2492.570
VIETNAM     222.331,    ROW        5399.888/,

GDEM0(R,RR)     GOODS DEMAND IN THE BASE CASE
PRCT0(R,RR)     CONSUMPTION PRICE OF TRADABLE GOODS IN BASE CASE
;


TABLE GDEM0(R,RR)
             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA      149.282       0.143       0.697       1.459       0.946
BAHRAIN          1.255      11.348       0.808                   0.118
BRAZIL           1.365       0.234     204.462       0.003       1.307
BRUNEI           0.066                   0.001       6.330       0.005
CANADA           2.876       0.082       6.826       0.023     258.067
CHILE            0.317       0.002       7.434       0.003       0.523
CHINA          169.529       0.401     112.608       0.864      21.884
EU              22.810       4.831      58.194       0.569      29.857
INDIA           18.973       1.297       5.634       1.260       2.235
INDONESIA        6.541       0.127       1.832       0.051       0.989
JAPAN           66.183       2.958       9.027       7.101       8.131
KOREA           28.153       1.259       4.805       1.793       3.739
KUWAIT                       1.567       0.325       0.003       0.144
MALAYSIA         6.700       0.225       2.229       1.172       0.485
MEXICO           0.591       0.132      10.609       0.004       9.267
NEWZEALAND       6.391       0.019       0.145       0.003       0.297
PERU             0.148       0.002       2.786                   0.429
PHILIPPINE       1.843       0.047       0.696       0.093       0.453
QATAR            0.844       0.018       0.349                   0.097
RUSSIAN          0.882       0.015       2.940                   0.469
ARABIA           0.869       3.426       2.797       0.003       1.098
SINGAPORE        7.395       0.276       1.907       1.537       1.000
THAILAND         7.379       0.340       2.322       2.307       0.584
US              25.146       4.154      71.955       0.543     383.772
VIETNAM          4.231       0.028       2.198       0.148       0.505
ROW             12.012      23.038      88.530       1.354      14.452

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        0.510      40.233      27.512       3.302       3.663
BAHRAIN          0.161       1.496       1.913       0.754       0.130
BRAZIL           4.851      25.318      26.624       3.287       1.820
BRUNEI           0.003       1.376       0.570       0.071       0.113
CANADA           2.930      62.223      48.436       5.199       2.718
CHILE           35.913      12.935       8.086       0.889       0.269
CHINA           51.477    3899.660     223.884      22.490      49.307
EU              19.574     483.836    2001.554      69.143      38.086
INDIA            2.658      59.575      40.236     797.475      20.836
INDONESIA        0.153      30.709       7.077       4.165     464.214
JAPAN           12.686     151.090      60.907       5.891      31.796
KOREA            7.187      86.926      44.261       5.914      14.594
KUWAIT           0.047       4.437       4.607       1.700       0.317
MALAYSIA         0.185      32.615      11.751       6.080      13.327
MEXICO           3.549      90.370      46.891       6.970       3.221
NEWZEALAND       0.134       6.611       4.758       0.479       0.923
PERU             2.060       7.704       3.139       0.851       0.411
PHILIPPINE       0.058      16.249       6.057       1.581       9.164
QATAR            0.020       2.825       8.456       1.768       0.202
RUSSIAN          1.644      41.241      74.221       3.136       2.541
ARABIA           0.234      17.891      26.254       5.629       2.381
SINGAPORE        0.146      40.403      33.379       7.278      19.836
THAILAND         0.664      37.309      12.332       4.472      11.270
US              35.517     833.284     659.147     102.814      51.261
VIETNAM          0.442      46.472       9.704       3.866       5.444
ROW              6.845     688.382    1260.187     209.463      51.715

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        3.355       8.493       0.105       9.627       0.503
BAHRAIN          0.718       0.239       0.320       0.181       0.042
BRAZIL           3.601       4.693       0.558       1.854       2.293
BRUNEI     9.507149E-4       0.097                   0.628       0.002
CANADA          15.726       9.311       0.119       4.080      10.780
CHILE            2.088       1.654                   0.303       1.095
CHINA          198.266     237.153      53.447      55.397       5.002
EU              97.772      74.714      14.478      52.142      22.857
INDIA           11.508      15.868      22.685      12.088       0.803
INDONESIA       13.749       7.333       0.647       9.637       0.139
JAPAN          758.090      33.432      22.651      24.733       2.052
KOREA           50.549     191.400      37.502      11.314       1.338
KUWAIT           1.771       1.250      33.307       0.378       0.112
MALAYSIA        13.431       8.673       1.292      21.138       0.199
MEXICO          22.323      21.652       0.066       3.726     130.893
NEWZEALAND       2.634       1.834       0.025       1.839       0.175
PERU             0.916       0.891       0.003       0.298       0.908
PHILIPPINE       9.302       9.903       3.602       5.122       0.080
QATAR            1.131       0.507       0.847       0.386       0.100
RUSSIAN          7.902       6.622                   2.135       0.533
ARABIA           4.993       4.138       1.204       1.559       0.431
SINGAPORE       20.447      13.821      11.906      46.611       1.375
THAILAND        29.865       7.905       2.492      17.446       0.351
US             244.815     134.873      11.295      55.360     367.143
VIETNAM         15.232      44.586       0.821      11.177       0.450
ROW            124.950      97.280      71.931      84.272      31.968

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        8.029       0.363       0.898       0.889       0.166
BAHRAIN          0.080       0.003       0.054                   0.104
BRAZIL           0.085       2.684       0.462       0.715       3.242
BRUNEI           0.008                   0.027       0.009       0.001
CANADA           1.174       2.384       2.795       0.264       1.605
CHILE            0.194       1.737       0.090                   0.069
CHINA           20.412      29.976      19.697      31.635      75.228
EU               8.061      15.196      22.756      31.851     246.373
INDIA            0.974       4.039       1.163      30.771       7.257
INDONESIA        1.036       0.077       1.510       3.417       1.379
JAPAN            4.386       4.342      19.265      46.426      17.882
KOREA            2.140       4.106       4.849      47.762      18.836
KUWAIT           0.096       0.006       0.123       0.136       0.224
MALAYSIA         1.182       0.171       3.394       1.828       1.148
MEXICO           0.599       1.043       1.532       0.229       2.809
NEWZEALAND      33.593       0.061       0.177       0.151       0.167
PERU             0.194      58.244       0.104       0.052       0.442
PHILIPPINE       0.709       0.158     109.143       1.005       1.234
QATAR            0.044       0.106       0.121      85.478       0.268
RUSSIAN          0.204       0.292       0.770       0.102     137.432
ARABIA           0.728       0.018       0.483                   1.295
SINGAPORE        1.250       0.022       8.054      19.830       6.182
THAILAND         1.021       0.205       4.742       9.473       2.358
US              12.275      24.885      36.480       8.602      42.121
VIETNAM          0.758       0.189       2.149       0.393       1.457
ROW              9.211      12.145      38.684      48.369     241.248

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        0.421       7.029      12.487      11.057       3.616
BAHRAIN          6.892       0.101       0.354       0.618       0.180
BRAZIL           2.146       0.538       1.870      13.756       1.963
BRUNEI           0.002       0.358       0.142       0.195       0.019
CANADA           3.981       1.187       4.558     161.275       4.205
CHILE            0.031       0.085       1.133       6.651       0.742
CHINA           56.470      37.247      67.647      97.193      52.422
EU              47.654      27.948      43.472     209.730      61.349
INDIA           29.215      13.352       9.619      17.023       6.926
INDONESIA        4.205      16.520      11.479       4.427       3.117
JAPAN           37.317       9.678      33.889      46.758      21.434
KOREA           27.293       7.437       7.081      31.005      19.472
KUWAIT           1.924       0.128       0.472       1.481       0.511
MALAYSIA         4.238      21.916      14.082       7.791       4.003
MEXICO           0.122       2.064      10.694     150.463       3.169
NEWZEALAND       0.376       1.290       2.284       2.176       0.639
PERU             0.178       0.060       0.477       4.517       0.354
PHILIPPINE       1.729       5.189       8.889       3.839       3.261
QATAR            0.014       0.176       0.411       2.865       0.243
RUSSIAN          0.293       0.784       2.278       6.444       2.526
ARABIA         114.467       1.185       2.491       9.329       1.667
SINGAPORE       13.054       9.394      10.488      22.034       3.691
THAILAND         6.937       6.568      40.739       7.299       5.145
US              46.239      45.440      75.938    2148.371      92.060
VIETNAM          1.319       4.825      13.204       4.769      68.732
ROW             92.531     345.110      63.694     314.807      52.413

         +         ROW

AUSTRALIA       57.779
BAHRAIN          4.767
BRAZIL          50.952
BRUNEI           0.309
CANADA         108.092
CHILE           16.390
CHINA         1311.406
EU            1595.593
INDIA          273.722
INDONESIA       31.213
JAPAN          198.209
KOREA          126.006
KUWAIT          12.528
MALAYSIA        54.781
MEXICO          82.543
NEWZEALAND       7.778
PERU            11.453
PHILIPPINE      17.106
QATAR            2.227
RUSSIAN         59.348
ARABIA          40.792
SINGAPORE      128.894
THAILAND        73.343
US             945.665
VIETNAM         70.082
ROW           1594.102 ;

TABLE PRCT0(R,RR)

             AUSTRALIA     BAHRAIN      BRAZIL      BRUNEI      CANADA

AUSTRALIA        0.835       1.126       1.847       0.823       2.343
BAHRAIN          1.569       0.599       1.694       0.529       2.661
BRAZIL           1.728       1.137       0.892       0.567       2.212
BRUNEI           1.640       0.941       1.403       0.500       2.145
CANADA           1.433       1.168       1.446       0.521       1.365
CHILE            1.511       0.635       1.298       0.530       2.141
CHINA            1.099       1.031       1.259       0.781       1.874
EU               1.280       0.938       1.288       1.030       1.857
INDIA            1.292       0.876       1.416       0.603       2.100
INDONESIA        1.350       1.242       1.672       0.816       2.387
JAPAN            1.151       0.973       1.451       0.762       1.930
KOREA            1.045       0.861       1.242       0.673       1.811
KUWAIT           1.619       0.915       1.594       0.523       2.683
MALAYSIA         1.043       0.891       1.337       0.631       1.950
MEXICO           1.553       1.366       1.377       0.539       1.743
NEWZEALAND       1.085       0.611       1.970       0.810       2.331
PERU             2.003       0.619       1.498       0.517       2.202
PHILIPPINE       1.482       0.637       1.743       0.970       2.329
QATAR            1.418       0.811       1.531       0.524       2.452
RUSSIAN          1.704       0.657       1.577       0.548       2.486
ARABIA           1.611       0.766       1.452       0.529       2.211
SINGAPORE        0.995       0.826       1.341       0.604       1.949
THAILAND         0.962       0.757       1.232       0.605       1.807
US               1.305       0.998       1.296       1.047       1.414
VIETNAM          1.126       0.656       1.370       0.741       1.973
ROW              1.019       0.652       1.055       0.768       1.691

         +       CHILE       CHINA          EU       INDIA   INDONESIA

AUSTRALIA        1.352       1.544       1.870       1.580       1.247
BAHRAIN          0.791       2.018       1.910       1.493       1.598
BRAZIL           1.086       1.654       1.761       1.620       1.445
BRUNEI           1.174       2.205       2.903       1.605       1.505
CANADA           1.172       1.610       1.660       1.571       1.348
CHILE            0.747       1.618       1.807       1.601       1.632
CHINA            1.030       1.172       1.591       1.439       1.126
EU               1.106       1.529       1.220       1.398       1.279
INDIA            1.172       1.653       1.671       1.021       1.126
INDONESIA        1.581       1.713       2.024       1.491       0.771
JAPAN            1.148       1.470       1.733       1.545       1.100
KOREA            0.980       1.335       1.531       1.329       1.009
KUWAIT           0.782       1.788       1.831       1.346       1.421
MALAYSIA         1.231       1.327       1.552       1.223       0.920
MEXICO           1.128       1.732       1.749       1.584       1.540
NEWZEALAND       1.514       1.775       1.962       1.803       1.381
PERU             1.097       1.870       2.069       1.839       1.870
PHILIPPINE       1.600       1.745       2.042       1.810       1.314
QATAR            1.592       1.725       1.654       1.301       1.348
RUSSIAN          1.579       1.652       1.475       1.695       1.469
ARABIA           1.617       1.597       1.660       1.244       1.242
SINGAPORE        1.358       1.325       1.464       1.153       0.844
THAILAND         1.077       1.341       1.455       1.201       0.902
US               1.054       1.507       1.566       1.431       1.264
VIETNAM          1.174       1.360       1.586       1.276       1.080
ROW              0.957       2.017       2.103       1.822       1.173

         +       JAPAN       KOREA      KUWAIT    MALAYSIA      MEXICO

AUSTRALIA        1.487       1.303       0.970       1.045       2.716
BAHRAIN          1.752       1.496       0.763       1.244       3.328
BRAZIL           1.753       1.448       0.893       1.252       2.252
BRUNEI           1.987       1.732       0.786       1.322       2.294
CANADA           1.524       1.381       0.983       1.195       1.864
CHILE            1.658       1.365       0.530       1.378       2.205
CHINA            1.352       1.179       0.762       0.946       2.156
EU               1.532       1.306       0.750       1.063       2.093
INDIA            1.632       1.355       0.659       1.001       2.265
INDONESIA        1.539       1.362       0.921       0.997       2.916
JAPAN            1.078       1.191       0.710       0.982       2.259
KOREA            1.234       1.040       0.606       0.972       1.979
KUWAIT           1.531       1.261       0.500       1.388       1.528
MALAYSIA         1.267       1.106       0.830       0.836       2.299
MEXICO           1.669       1.411       0.539       1.317       1.460
NEWZEALAND       1.688       1.465       0.510       1.113       2.785
PERU             1.916       1.552       0.517       1.609       2.474
PHILIPPINE       1.575       1.357       1.131       1.108       2.745
QATAR            1.372       1.173       0.816       1.136       2.814
RUSSIAN          1.598       1.358       0.548       1.361       2.824
ARABIA           1.459       1.190       0.773       1.187       2.762
SINGAPORE        1.293       1.054       0.906       0.971       2.165
THAILAND         1.227       1.191       0.774       0.932       1.972
US               1.437       1.261       0.752       1.047       1.563
VIETNAM          1.289       1.154       0.875       0.943       2.376
ROW              1.224       1.162       0.591       0.945       1.819

         +  NEWZEALAND        PERU  PHILIPPINE       QATAR     RUSSIAN

AUSTRALIA        0.993       1.753       1.182       0.849       1.990
BAHRAIN          0.809       0.774       0.705       0.677       1.033
BRAZIL           1.687       1.227       1.300       0.858       1.723
BRUNEI           1.482       1.148       1.505       0.786       1.533
CANADA           1.305       1.179       1.137       0.898       1.777
CHILE            1.549       1.073       1.427       1.066       2.063
CHINA            1.157       1.165       0.991       0.735       1.374
EU               1.229       1.239       1.115       0.678       1.179
INDIA            1.349       1.316       1.180       0.637       1.620
INDONESIA        1.369       1.772       1.135       0.874       1.858
JAPAN            1.196       1.298       0.973       0.636       1.445
KOREA            1.076       1.090       0.868       0.578       1.273
KUWAIT           0.800       0.765       1.507       0.816       1.021
MALAYSIA         1.018       1.406       0.882       0.679       1.588
MEXICO           1.458       1.238       1.252       0.964       1.887
NEWZEALAND       0.764       1.596       1.187       0.863       1.899
PERU             1.669       0.731       1.532       0.517       2.121
PHILIPPINE       1.362       1.681       0.666       0.887       2.040
QATAR            1.319       0.766       1.182       0.500       2.178
RUSSIAN          1.488       1.589       1.393       1.116       0.975
ARABIA           1.272       1.840       1.256       0.706       1.979
SINGAPORE        0.989       1.563       0.809       0.559       1.527
THAILAND         0.977       1.149       0.804       0.563       1.378
US               1.237       1.135       1.074       0.770       1.541
VIETNAM          1.125       1.541       0.988       0.729       1.411
ROW              1.005       1.007       1.143       0.604       1.100

         +      ARABIA   SINGAPORE    THAILAND          US     VIETNAM

AUSTRALIA        1.930       1.278       1.008       2.460       1.323
BAHRAIN          1.279       1.479       1.105       2.624       1.125
BRAZIL           1.627       1.611       1.207       2.287       1.505
BRUNEI           1.572       1.744       1.424       3.800       1.766
CANADA           1.620       1.531       1.157       1.769       1.418
CHILE            2.166       1.950       1.260       2.221       1.541
CHINA            1.362       1.211       1.035       2.023       1.137
EU               1.361       1.286       1.043       2.021       1.275
INDIA            1.219       1.269       1.029       2.207       1.226
INDONESIA        1.611       1.174       1.022       2.580       1.374
JAPAN            1.353       1.285       0.995       2.098       1.173
KOREA            1.144       1.300       1.001       1.908       1.185
KUWAIT           1.547       1.944       1.354       2.369       1.717
MALAYSIA         1.420       1.245       0.974       1.971       1.204
MEXICO           1.892       1.590       1.181       1.843       1.596
NEWZEALAND       1.665       1.388       1.118       2.548       1.443
PERU             2.519       2.295       1.375       2.444       2.069
PHILIPPINE       1.886       1.302       1.056       2.539       1.455
QATAR            1.413       1.199       0.984       2.426       1.431
RUSSIAN          2.029       1.679       1.235       2.487       1.419
ARABIA           1.000       1.409       1.158       2.150       1.393
SINGAPORE        1.314       1.073       0.987       1.884       0.989
THAILAND         1.325       1.210       0.874       1.859       1.209
US               1.366       1.283       1.032       1.574       1.275
VIETNAM          1.421       1.189       0.990       2.046       0.980
ROW              1.152       1.253       0.969       1.744       1.602

         +         ROW

AUSTRALIA        0.957
BAHRAIN          0.931
BRAZIL           0.926
BRUNEI           1.453
CANADA           0.971
CHILE            1.004
CHINA            0.956
EU               0.881
INDIA            0.955
INDONESIA        1.192
JAPAN            0.889
KOREA            0.953
KUWAIT           0.927
MALAYSIA         0.886
MEXICO           0.976
NEWZEALAND       1.031
PERU             1.080
PHILIPPINE       1.345
QATAR            0.946
RUSSIAN          0.884
ARABIA           0.902
SINGAPORE        0.916
THAILAND         0.931
US               0.842
VIETNAM          1.280
ROW              0.783 ;

PARAMETER
PRODUCTION(R)     TOTAL PRODUCTION OF TRADABLE GOODS
EXPORT(R)         TOTAL EXPORT OF ONE COUNTRY
IMPORT(R)         TOTAL IMPORT OF ONE COUNTRY
TRADE(R)          TOTAL TRADE OF ONE COUNTRY
UTILITY(R)        TOTAL UTILITY OF ONE COUNTRY
EMPLOYMENT(R)     EXPLOYMENT IN TRADABLE SECTORS
BALANCE(R)        TRADE IMBALANCE
EV(R)             EQUIVALEND VARIATION
CV(R)             COMPENSATION VARIATION

CPRODUCTION       PERCENT CHANGE OF TOTAL PRODUCTION
CEXPORT(R)        PERCENT CHANGE OF TOTAL EXPORT FOR ONE COUNTRY
CIMPORT(R)        PERCENT CHANGE OF TOTAL IMPORT OF ONE COUNTRY
CTRADE(R)         PERCENT CHANGE OF TOTAL TRADE OF ONE COUNTRY
CBALANCE(R)       PERCENT CHANGE OF TRADE IMBALANCE
CUTILITY(R)       PERCENT CHANGE OF UTILITY OF ONE COUNTRY
CEMPLOYMENT(R)    PERCENT CHANGE OF EMPLOYMENT IN TRADABLE SECTOR
EVGDP(R)          EV AS SHARE OF GDP
CVGDP(R)          CV AS SHARE OF GDP

WUTILITY          PERCENT CHANGE OF WORLD UTILITY
WPRODUCTION       PERCENT CHANGE OF WORLD PRODUCTION
WMANUFACTURE      PERCENT CHANGE OF MANUFACTURE SECTOR
WNONMANUFACTURE   PERCENT CHANGE OF NONMANUFACTURE SECTOR
WEMPLOYMENT       PERCENT CHANGE OF WORLD EMPLOYMENT
WTRADE            PERCENT CHANGE OF WORLD TRADE
WEXPORT           PERCENT CHANGE OF WORLD EXPORT
WIMPORT           PERCENT CHANGE OF WORLD IMPORT
;


PRODUCTION(R) = SUM(GG,PRN.L(R,GG)*P.L(R,GG));
EXPORT(R) =  SUM(RR,GDEM.L(RR,R)*P.L(R,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
IMPORT(R) =  SUM(RR,GDEM.L(R,RR)*P.L(RR,"TRADABLE"))-GDEM.L(R,R)*P.L(R,"TRADABLE");
TRADE(R) = EXPORT(R)+IMPORT(R);
BALANCE(R) = EXPORT(R)-IMPORT(R);
UTILITY(R) = INC.L(R)*(SHARE1(R)*(PM.L(R)**(1-ELASC1(R)))+SHARE2(R)*(PRCN.L(R)**
(1-ELASC1(R)))) **(1/(ELASC1(R)-1));
EMPLOYMENT(R) = FACDEM.L(R,"TRADABLE","L");
EV(R) = (SUM(RR,GDEM.L(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT0(R,RR))+PRCN0(R)*NGDEM0(R));;
CV(R )= (SUM(RR,GDEM.L(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM.L(R))- (SUM(RR,GDEM0(R,RR)*PRCT.L(R,RR))+PRCN.L(R)*NGDEM0(R));

CEXPORT(R) = (EXPORT(R)-EXPORT0(R))*100/EXPORT0(R);
CIMPORT(R) = (IMPORT(R)-IMPORT0(R))*100/IMPORT0(R);
CTRADE(R) = (TRADE(R)-TRADE0(R))*100/TRADE0(R);
CBALANCE(R) = (BALANCE(R)-BALANCE0(R))*100/BALANCE0(R);
CPRODUCTION(R) = (PRODUCTION(R)-PRODUCTION0(R))*100/PRODUCTION0(R);
CUTILITY(R) = (UTILITY(R)-UTILITY0(R))*100/UTILITY0(R);
CEMPLOYMENT(R) = (EMPLOYMENT(R)-EMPLOYMENT0(R))*100/EMPLOYMENT0(R);
EVGDP(R) = EV(R)*100/PRODUCTION(R);
CVGDP(R) = CV(R)*100/PRODUCTION(R);

WUTILITY = (SUM(R,UTILITY(R))-SUM(R,UTILITY0(R)))*100/SUM(R,UTILITY0(R));
WPRODUCTION = (SUM(R,PRODUCTION(R))-SUM(R,PRODUCTION0(R)))*100/SUM(R,PRODUCTION0(R));
WEMPLOYMENT = (SUM(R,EMPLOYMENT(R))-SUM(R,EMPLOYMENT0(R)))*100/SUM(R,EMPLOYMENT0(R));
WTRADE = (SUM(R,TRADE(R))-SUM(R,TRADE0(R)))*100/SUM(R,TRADE0(R));
WEXPORT = (SUM(R,EXPORT(R))-SUM(R,EXPORT0(R)))*100/SUM(R,EXPORT0(R));
WIMPORT = (SUM(R,IMPORT(R))-SUM(R,IMPORT0(R)))*100/SUM(R,IMPORT0(R));


DISPLAY CUTILITY,CPRODUCTION,CEMPLOYMENT,CEXPORT,CIMPORT,CTRADE,CBALANCE,CVGDP,EVGDP
WUTILITY,WPRODUCTION,WEMPLOYMENT,WTRADE,WEXPORT,WIMPORT;
